// Copyright (c) 1998-2005 B2C2, Incorporated.  All Rights Reserved.
//
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF B2C2, INCORPORATED.
// The copyright notice above does not evidence any
// actual or intended publication of such source code.
//
// This file is proprietary source code of B2C2, Incorporated. and is released pursuant to and
// subject to the restrictions of the non-disclosure agreement and license contract entered
// into by the parties.
//
//
// AVPlaybackDlg.h : header file
//

#include "afxcmn.h"
#if !defined(AFX_AVPLAYBACKDLG_H__BDED3319_1EA9_4D60_A06A_46CAB2B7362A__INCLUDED_)
#define AFX_AVPLAYBACKDLG_H__BDED3319_1EA9_4D60_A06A_46CAB2B7362A__INCLUDED_


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CAVPlaybackCtrl;

/////////////////////////////////////////////////////////////////////////////
// CAVPlaybackDlg dialog

class CAVPlaybackDlg : public CDialog
{
// Construction / Destruction
public:
	CAVPlaybackDlg(CWnd* pParent = NULL);	// standard constructor
	virtual ~CAVPlaybackDlg();	// destructor

// Dialog Data
	//{{AFX_DATA(CAVPlaybackDlg)
	enum { IDD = IDD_SDKDEMO_DIALOG };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAVPlaybackDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

public:

	void StopStatusTimer();
	void StartStatusTimer();

	void UpdateMainWindow();
	void CalcMainWindow();

	void CalcVideoWindowSize(BOOL bUseFrame, BOOL bModifyY);

	void UpdateVideoWindow();

	void UpdateButtons();

	void UpdateStatusBar();

	DWORD GetStatusBarHeight();
	CPoint GetButtonSize();
	CPoint GetButtonDistance();
	DWORD GetBorderHeight();
	DWORD GetButtonListHeight();

	void UpdateState();

	inline void PassAudioVideoPID(int iAudioPID, int iVideoPID)
	{
		m_iAudioPID = iAudioPID;
		m_iVideoPID = iVideoPID;
	};
	inline void PassAutoDeleteTimeshift(BOOL bAutoDeleteTimeshift)
	{
		m_bAutoDeleteTimeshift = bAutoDeleteTimeshift;
	};
	inline void PassAutoStartTimeshift(BOOL bAutoStartTimeshift)
	{
		m_bAutoStartTimeshift = bAutoStartTimeshift;
	};
	void PassB2C2MPEG2Adapter(CB2FilterGraphHandler* pB2FilterGraph)
	{
		m_pB2FilterGraph = pB2FilterGraph;
	}


// Implementation
protected:
	static CString Value2String(__int64 llValue);
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CAVPlaybackDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnDestroy();
	afx_msg void OnBtPlay();
	afx_msg void OnBtStop();
	afx_msg void OnBtRecord();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnBnClickedBtJumpToStart();
	afx_msg void OnBnClickedBtJumpToEnd();
	afx_msg void OnSizing(UINT nSide, LPRECT lpRect);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private: // Member variables

	CB2FilterGraphHandler		*m_pB2FilterGraph;

	CAVPlaybackCtrl *m_pAVPlaybackCtrl;

	int m_iAudioPID;
	int m_iVideoPID;
	BOOL m_bAutoDeleteTimeshift;
	BOOL m_bAutoStartTimeshift;

	double	m_dfRatio;
	BOOL	m_bLockRatio;

	CPoint	m_cpVidSize;
	CRect	m_crVidFrame;

	CRect	m_crChildPos;
	CRect	m_crMainWnd;

	CRect	m_crButtons;
	CRect	m_crStatusBar;
	CRect	m_crSliderCtrl;

	CStatusBarCtrl	m_cStatusBar;
	int				m_iStatusBarHeight;

	CSliderCtrl m_cSliderCtrl;
	int	m_iSliderCtrlHeight;

	BOOL m_bScrollBarRepositioning;

	UINT 	m_nStatusTimer;

	int m_nSliderPosition;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_AVPLAYBACKDLG_H__BDED3319_1EA9_4D60_A06A_46CAB2B7362A__INCLUDED_)
